using System;
using System.Drawing;
using System.Collections;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using System.Diagnostics;
using System.Threading;
using System.Globalization;
using System.Timers;

using nsAlienRFID2;

namespace Ex7
{
	public delegate void displayMessagesDelegate(object o, string msg);

	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private clsReaderMonitor mMonitor;
		private System.Timers.Timer mTimer;
		private Queue mSerialAddedQ = new Queue();
		private Queue mSerialRemovedQ = new Queue();
		private Queue mSerialRenewedQ = new Queue();
		private Queue mNetworkAddedQ = new Queue();
		private Queue mNetworkRemovedQ = new Queue();
		private Queue mNetworkRenewedQ = new Queue();
		private bool mbClosing;

		#region Auto generated code

		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.GroupBox groupBox3;
		private System.Windows.Forms.CheckBox chkListenHeartbeats;
		private System.Windows.Forms.NumericUpDown PortUD;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.GroupBox groupBox4;
		private System.Windows.Forms.CheckBox chkListenSerial;
		private System.Windows.Forms.NumericUpDown UpdateUD;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Button btnClearNetworkReaders;
		private System.Windows.Forms.Button btnClearSerialReaders;
		private System.Windows.Forms.Button btnClearAllReaders;
		private System.Windows.Forms.ListBox lbNetworkReaders;
		private System.Windows.Forms.ListBox lbSerialReaders;
		private System.ComponentModel.IContainer components;

		public Form1()
		{
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
            this.chkListenHeartbeats = new System.Windows.Forms.CheckBox();
            this.chkListenSerial = new System.Windows.Forms.CheckBox();
            this.UpdateUD = new System.Windows.Forms.NumericUpDown();
            this.groupBox3 = new System.Windows.Forms.GroupBox();
            this.lbNetworkReaders = new System.Windows.Forms.ListBox();
            this.PortUD = new System.Windows.Forms.NumericUpDown();
            this.label1 = new System.Windows.Forms.Label();
            this.btnClearNetworkReaders = new System.Windows.Forms.Button();
            this.label4 = new System.Windows.Forms.Label();
            this.groupBox4 = new System.Windows.Forms.GroupBox();
            this.lbSerialReaders = new System.Windows.Forms.ListBox();
            this.btnClearSerialReaders = new System.Windows.Forms.Button();
            this.btnClearAllReaders = new System.Windows.Forms.Button();
            ((System.ComponentModel.ISupportInitialize)(this.UpdateUD)).BeginInit();
            this.groupBox3.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.PortUD)).BeginInit();
            this.groupBox4.SuspendLayout();
            this.SuspendLayout();
            // 
            // chkListenHeartbeats
            // 
            this.chkListenHeartbeats.Font = new System.Drawing.Font("Microsoft Sans Serif", 7.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.chkListenHeartbeats.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.chkListenHeartbeats.Location = new System.Drawing.Point(88, 0);
            this.chkListenHeartbeats.Name = "chkListenHeartbeats";
            this.chkListenHeartbeats.Size = new System.Drawing.Size(60, 19);
            this.chkListenHeartbeats.TabIndex = 30;
            this.chkListenHeartbeats.Text = "Listen";
            this.toolTip1.SetToolTip(this.chkListenHeartbeats, "Starts/Stops listening for notifications");
            this.chkListenHeartbeats.CheckedChanged += new System.EventHandler(this.chkListenHeartbeats_CheckedChanged);
            // 
            // chkListenSerial
            // 
            this.chkListenSerial.Font = new System.Drawing.Font("Microsoft Sans Serif", 7.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.chkListenSerial.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.chkListenSerial.Location = new System.Drawing.Point(112, 0);
            this.chkListenSerial.Name = "chkListenSerial";
            this.chkListenSerial.Size = new System.Drawing.Size(56, 19);
            this.chkListenSerial.TabIndex = 31;
            this.chkListenSerial.Text = "Listen";
            this.toolTip1.SetToolTip(this.chkListenSerial, "Starts/Stops listening for notifications");
            this.chkListenSerial.CheckedChanged += new System.EventHandler(this.chkListenSerial_CheckedChanged);
            // 
            // UpdateUD
            // 
            this.UpdateUD.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.UpdateUD.Font = new System.Drawing.Font("Microsoft Sans Serif", 7.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.UpdateUD.Location = new System.Drawing.Point(304, 151);
            this.UpdateUD.Maximum = new decimal(new int[] {
            60,
            0,
            0,
            0});
            this.UpdateUD.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.UpdateUD.Name = "UpdateUD";
            this.UpdateUD.Size = new System.Drawing.Size(56, 19);
            this.UpdateUD.TabIndex = 49;
            this.UpdateUD.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            this.UpdateUD.ThousandsSeparator = true;
            this.toolTip1.SetToolTip(this.UpdateUD, "Time");
            this.UpdateUD.Value = new decimal(new int[] {
            5,
            0,
            0,
            0});
            this.UpdateUD.ValueChanged += new System.EventHandler(this.UpdateUD_ValueChanged);
            // 
            // groupBox3
            // 
            this.groupBox3.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)));
            this.groupBox3.Controls.Add(this.lbNetworkReaders);
            this.groupBox3.Controls.Add(this.PortUD);
            this.groupBox3.Controls.Add(this.chkListenHeartbeats);
            this.groupBox3.Controls.Add(this.label1);
            this.groupBox3.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.groupBox3.Location = new System.Drawing.Point(16, 16);
            this.groupBox3.Name = "groupBox3";
            this.groupBox3.Size = new System.Drawing.Size(312, 127);
            this.groupBox3.TabIndex = 46;
            this.groupBox3.TabStop = false;
            this.groupBox3.Text = "On Network: ";
            // 
            // lbNetworkReaders
            // 
            this.lbNetworkReaders.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.lbNetworkReaders.BackColor = System.Drawing.SystemColors.WindowText;
            this.lbNetworkReaders.ForeColor = System.Drawing.Color.Yellow;
            this.lbNetworkReaders.ItemHeight = 16;
            this.lbNetworkReaders.Location = new System.Drawing.Point(24, 32);
            this.lbNetworkReaders.Name = "lbNetworkReaders";
            this.lbNetworkReaders.Size = new System.Drawing.Size(272, 68);
            this.lbNetworkReaders.TabIndex = 40;
            // 
            // PortUD
            // 
            this.PortUD.Font = new System.Drawing.Font("Microsoft Sans Serif", 7.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.PortUD.Location = new System.Drawing.Point(248, 0);
            this.PortUD.Maximum = new decimal(new int[] {
            10000,
            0,
            0,
            0});
            this.PortUD.Name = "PortUD";
            this.PortUD.Size = new System.Drawing.Size(56, 19);
            this.PortUD.TabIndex = 38;
            this.PortUD.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            this.PortUD.Value = new decimal(new int[] {
            3988,
            0,
            0,
            0});
            // 
            // label1
            // 
            this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label1.Location = new System.Drawing.Point(160, 0);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(96, 16);
            this.label1.TabIndex = 39;
            this.label1.Text = "Heartbeat Port:";
            // 
            // btnClearNetworkReaders
            // 
            this.btnClearNetworkReaders.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.btnClearNetworkReaders.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.btnClearNetworkReaders.Font = new System.Drawing.Font("Microsoft Sans Serif", 7.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnClearNetworkReaders.ForeColor = System.Drawing.SystemColors.WindowText;
            this.btnClearNetworkReaders.Location = new System.Drawing.Point(40, 183);
            this.btnClearNetworkReaders.Name = "btnClearNetworkReaders";
            this.btnClearNetworkReaders.Size = new System.Drawing.Size(136, 26);
            this.btnClearNetworkReaders.TabIndex = 40;
            this.btnClearNetworkReaders.Text = "Clear &Network Readers";
            this.btnClearNetworkReaders.UseVisualStyleBackColor = false;
            this.btnClearNetworkReaders.Click += new System.EventHandler(this.btnClearNetworkReaders_Click);
            // 
            // label4
            // 
            this.label4.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.label4.Font = new System.Drawing.Font("Microsoft Sans Serif", 7.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label4.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label4.Location = new System.Drawing.Point(208, 151);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(96, 19);
            this.label4.TabIndex = 48;
            this.label4.Text = "Update Time (sec): ";
            // 
            // groupBox4
            // 
            this.groupBox4.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.groupBox4.Controls.Add(this.lbSerialReaders);
            this.groupBox4.Controls.Add(this.chkListenSerial);
            this.groupBox4.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.groupBox4.Location = new System.Drawing.Point(336, 16);
            this.groupBox4.Name = "groupBox4";
            this.groupBox4.Size = new System.Drawing.Size(312, 127);
            this.groupBox4.TabIndex = 47;
            this.groupBox4.TabStop = false;
            this.groupBox4.Text = "On Serial ports: ";
            // 
            // lbSerialReaders
            // 
            this.lbSerialReaders.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.lbSerialReaders.BackColor = System.Drawing.SystemColors.WindowText;
            this.lbSerialReaders.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.lbSerialReaders.ItemHeight = 16;
            this.lbSerialReaders.Location = new System.Drawing.Point(24, 32);
            this.lbSerialReaders.Name = "lbSerialReaders";
            this.lbSerialReaders.Size = new System.Drawing.Size(272, 68);
            this.lbSerialReaders.TabIndex = 41;
            // 
            // btnClearSerialReaders
            // 
            this.btnClearSerialReaders.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.btnClearSerialReaders.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.btnClearSerialReaders.Font = new System.Drawing.Font("Microsoft Sans Serif", 7.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnClearSerialReaders.ForeColor = System.Drawing.SystemColors.WindowText;
            this.btnClearSerialReaders.Location = new System.Drawing.Point(512, 183);
            this.btnClearSerialReaders.Name = "btnClearSerialReaders";
            this.btnClearSerialReaders.Size = new System.Drawing.Size(136, 26);
            this.btnClearSerialReaders.TabIndex = 32;
            this.btnClearSerialReaders.Text = "Clear &Serial Readers";
            this.btnClearSerialReaders.UseVisualStyleBackColor = false;
            this.btnClearSerialReaders.Click += new System.EventHandler(this.btnClearSerialReaders_Click);
            // 
            // btnClearAllReaders
            // 
            this.btnClearAllReaders.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.btnClearAllReaders.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.btnClearAllReaders.Font = new System.Drawing.Font("Microsoft Sans Serif", 7.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnClearAllReaders.ForeColor = System.Drawing.SystemColors.WindowText;
            this.btnClearAllReaders.Location = new System.Drawing.Point(272, 183);
            this.btnClearAllReaders.Name = "btnClearAllReaders";
            this.btnClearAllReaders.Size = new System.Drawing.Size(128, 26);
            this.btnClearAllReaders.TabIndex = 50;
            this.btnClearAllReaders.Text = "Clear &All Readers";
            this.btnClearAllReaders.UseVisualStyleBackColor = false;
            this.btnClearAllReaders.Click += new System.EventHandler(this.btnClearAllReaders_Click);
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
            this.BackColor = System.Drawing.SystemColors.ControlText;
            this.ClientSize = new System.Drawing.Size(664, 225);
            this.Controls.Add(this.btnClearAllReaders);
            this.Controls.Add(this.groupBox4);
            this.Controls.Add(this.groupBox3);
            this.Controls.Add(this.UpdateUD);
            this.Controls.Add(this.label4);
            this.Controls.Add(this.btnClearNetworkReaders);
            this.Controls.Add(this.btnClearSerialReaders);
            this.Font = new System.Drawing.Font("Microsoft Sans Serif", 7.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.MaximumSize = new System.Drawing.Size(672, 584);
            this.MinimumSize = new System.Drawing.Size(672, 252);
            this.Name = "Form1";
            this.Text = "Alien Example 7 (Monitoring)";
            this.Load += new System.EventHandler(this.Form1_Load);
            this.Closing += new System.ComponentModel.CancelEventHandler(this.Form1_Closing);
            ((System.ComponentModel.ISupportInitialize)(this.UpdateUD)).EndInit();
            this.groupBox3.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.PortUD)).EndInit();
            this.groupBox4.ResumeLayout(false);
            this.ResumeLayout(false);

		}

		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		#endregion

		private void Form1_Load(object sender, System.EventArgs e)
		{
			mMonitor = new clsReaderMonitor();
			mMonitor.ComPortsMonitoring = false;
			mMonitor.NetworkMonitoring = false;

			mTimer = new System.Timers.Timer();
			mTimer.Elapsed += new ElapsedEventHandler(mTimer_Elapsed);
			mTimer.SynchronizingObject = this;
			mTimer.Start();

			chkListenHeartbeats.Checked = true;

			this.Text = "Alien Library .NET - Testing Monitoring Readers";
			Thread.CurrentThread.Name = "Alien-Ex.7: Test Monitoring Readers";
			mMonitor.UpdateInterval = (int)UpdateUD.Value * 1000;

			mMonitor.StartListening();
		}


		private void Form1_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			if (mMonitor != null)
			{
				mMonitor.StopListening();
				mMonitor.Dispose();
			}
			mbClosing = true;
			mTimer.Stop();
			mTimer.Dispose();
		}


		private void UpdateUD_ValueChanged(object sender, System.EventArgs e)
		{
			mMonitor.UpdateInterval = (int)UpdateUD.Value * 1000;
		}

		private void PortUD_ValueChanged(object sender, System.EventArgs e)
		{
			mMonitor.Port = (int)PortUD.Value;
		}

		
		#region "Alien Events"...

		private void mMonitor_NetworkReaderAdded(IReaderInfo data)
		{
			string item = data.Name + " on " + data.IPAddress;
			lock (mNetworkAddedQ.SyncRoot)
			{
				mNetworkAddedQ.Enqueue(item);
			}
		}

		private void mMonitor_NetworkReaderRenewed(IReaderInfo data)
		{
			string item = data.Name + " on " + data.IPAddress;
			lock (mNetworkRenewedQ.SyncRoot)
			{
				mNetworkRenewedQ.Enqueue(item);
			}
		}

		private void mMonitor_NetworkReaderRemoved(IReaderInfo data)
		{
			string item = data.Name + " on " + data.IPAddress;
			lock (mNetworkRemovedQ.SyncRoot)
			{
				mNetworkRemovedQ.Enqueue(item);
			}
		}
		

		private void mMonitor_SerialReaderAdded(IReaderInfo data)
		{
			string item = data.Name + " on " + data.IPAddress;
			lock (mSerialAddedQ.SyncRoot)
			{
				mSerialAddedQ.Enqueue(item);
			}
		}

		private void mMonitor_SerialReaderRenewed(IReaderInfo data)
		{
			string item = data.Name + " on " + data.IPAddress;
			lock (mSerialRenewedQ.SyncRoot)
			{
				mSerialRenewedQ.Enqueue(item);
			}
		}

		private void mMonitor_SerialReaderRemoved(IReaderInfo data)
		{
			string item = data.Name + " on " + data.IPAddress;
			lock (mSerialRemovedQ.SyncRoot)
			{
				mSerialRemovedQ.Enqueue(item);
			}
		}
		
		#endregion


		private void chkListenHeartbeats_CheckedChanged(object sender, System.EventArgs e)
		{
			bool state = chkListenHeartbeats.Checked;
			mMonitor.NetworkMonitoring = state;
			if (state)
			{
				mMonitor.ReaderAddedOnNetwork += new clsReaderMonitor.ReaderAddedOnNetworkEventHandler(mMonitor_NetworkReaderAdded);
				mMonitor.ReaderRenewedOnNetwork +=new clsReaderMonitor.ReaderRenewedOnNetworkEventHandler(mMonitor_NetworkReaderRenewed);
				mMonitor.ReaderRemovedOnNetwork +=new clsReaderMonitor.ReaderRemovedOnNetworkEventHandler(mMonitor_NetworkReaderRemoved);
			}
			else
			{
				mMonitor.ReaderAdded -= new clsReaderMonitor.ReaderAddedEventHandler(mMonitor_NetworkReaderAdded);
				mMonitor.ReaderRenewed -=new clsReaderMonitor.ReaderRenewedEventHandler(mMonitor_NetworkReaderRenewed);
				mMonitor.ReaderRemoved -=new clsReaderMonitor.ReaderRemovedEventHandler(mMonitor_NetworkReaderRemoved);
			}

			PortUD.Enabled = !state;
		}

		private void chkListenSerial_CheckedChanged(object sender, System.EventArgs e)
		{
			bool state = chkListenSerial.Checked;
			mMonitor.ComPortsMonitoring = state;
			if (state)
			{
				mMonitor.ReaderAddedOnSerial += new clsReaderMonitor.ReaderAddedOnSerialEventHandler(mMonitor_SerialReaderAdded);
				mMonitor.ReaderRenewedOnSerial +=new clsReaderMonitor.ReaderRenewedOnSerialEventHandler(mMonitor_SerialReaderRenewed);
				mMonitor.ReaderRemovedOnSerial +=new clsReaderMonitor.ReaderRemovedOnSerialEventHandler(mMonitor_SerialReaderRemoved);
			}
			else
			{
				mMonitor.ReaderAddedOnSerial -= new clsReaderMonitor.ReaderAddedOnSerialEventHandler(mMonitor_SerialReaderAdded);
				mMonitor.ReaderRenewedOnSerial -=new clsReaderMonitor.ReaderRenewedOnSerialEventHandler(mMonitor_SerialReaderRenewed);
				mMonitor.ReaderRemovedOnSerial -=new clsReaderMonitor.ReaderRemovedOnSerialEventHandler(mMonitor_SerialReaderRemoved);
			}

		}

		private void btnClearAllReaders_Click(object sender, System.EventArgs e)
		{
			btnClearNetworkReaders_Click(null, null);
			btnClearSerialReaders_Click(null, null);
		}

		private void btnClearNetworkReaders_Click(object sender, System.EventArgs e)
		{
			mMonitor.ClearNetworkReaders();
			lock (mNetworkAddedQ.SyncRoot) { mNetworkAddedQ.Clear(); }
			lock (mNetworkRenewedQ.SyncRoot) { mNetworkRenewedQ.Clear(); }
			lock (mNetworkRemovedQ.SyncRoot) { mNetworkRemovedQ.Clear(); }
			lbNetworkReaders.Items.Clear();
		}

		private void btnClearSerialReaders_Click(object sender, System.EventArgs e)
		{
			mMonitor.ClearSerialReaders();
			lock (mSerialAddedQ.SyncRoot) { mSerialAddedQ.Clear(); }
			lock (mSerialRenewedQ.SyncRoot) { mSerialRenewedQ.Clear(); }
			lock (mSerialRemovedQ.SyncRoot) { mSerialRemovedQ.Clear(); }
			lbSerialReaders.Items.Clear();
		}

		private void mTimer_Elapsed(object sender, ElapsedEventArgs e)
		{
			if (mTimer != null)
			{
				mTimer.Stop();
				#region "Update Network Readers ListBox"...
				lock (mNetworkAddedQ.SyncRoot)
				{
					if (mNetworkAddedQ.Count > 0)
					{
						string item = (string)mNetworkAddedQ.Dequeue();
						if (lbNetworkReaders.FindStringExact(item) == ListBox.NoMatches)
							lbNetworkReaders.Items.Add(item);
						lbNetworkReaders.SelectedItem = item;
					}
				}
				lock (mNetworkRenewedQ.SyncRoot)
				{
					if (mNetworkRenewedQ.Count > 0)
					{
						string item = (string)mNetworkRenewedQ.Dequeue();
						int idx = lbNetworkReaders.FindStringExact(item);
						if (idx != ListBox.NoMatches)
							lbNetworkReaders.SelectedIndex = idx;
					}
				}
				lock (mNetworkRemovedQ.SyncRoot)
				{
					if (mNetworkRemovedQ.Count > 0)
					{
						string item = (string)mNetworkRemovedQ.Dequeue();
						lbNetworkReaders.Items.Remove(item);
					}
				}
				#endregion
				#region "Update Serial Readers List Box"...
				lock (mSerialAddedQ.SyncRoot)
				{
					if (mSerialAddedQ.Count > 0)
					{
						string item = (string)mSerialAddedQ.Dequeue();
						if (lbSerialReaders.FindStringExact(item) == ListBox.NoMatches)
							lbSerialReaders.Items.Add(item);
						lbSerialReaders.SelectedItem = item;
					}
				}
				lock (mSerialRenewedQ.SyncRoot)
				{
					if (mSerialRenewedQ.Count > 0)
					{
						string item = (string)mSerialRenewedQ.Dequeue();
						int idx = lbSerialReaders.FindStringExact(item);
						if (idx != ListBox.NoMatches)
							lbSerialReaders.SelectedIndex = idx;
					}
				}
				lock (mSerialRemovedQ.SyncRoot)
				{
					if (mSerialRemovedQ.Count > 0)
					{
						string item = (string)mSerialRemovedQ.Dequeue();
						lbSerialReaders.Items.Remove(item);
					}
				}

				#endregion
				
				if (!mbClosing)
					mTimer.Start();
			}
		}
	}
}
